from enum import Enum
from log import logger
from typing import Tuple


log = logger()

class TipoLocale(Enum):
    Sconosciuto = -1
    AulaMultimediale = 1
    '''DEPRECATED'''
    Aula = 2
    AulaAttrezzata = 3
    '''DEPRECATED'''
    Laboratorio = 4
    '''Mi vanno bene tutti i tipi di laboratorio'''
    LABINF = 5
    LAIB = 6
    LADISPE = 7
    LED = 8
    LED1 = 9
    LED2 = 10
    ACSLAB = 11
    Aula5T = 12
    Aula_CA2 = 13
    Aula_CA = 14
    Aula_TB = 15
    Aula_WB = 16
    
def getTipoLocaleFromString(tipoLocale:str) -> TipoLocale:
    if tipoLocale == "Aula multimediale":
        log.warning_log("customTypes.getTipoLocaleFromString(): TipoLocale deprecated -> get Aula")
        return TipoLocale.Aula
    elif tipoLocale == "Aula":
        return TipoLocale.Aula
    elif tipoLocale == "Aula attrezzata":
        log.warning_log("customTypes.getTipoLocaleFromString(): TipoLocale deprecated -> get Aula")
        return TipoLocale.Aula
    elif tipoLocale == "Laboratorio":
        log.warning_log("customTypes.getTipoLocaleFromString(): TipoLocale deprecated")
        return TipoLocale.Laboratorio
    elif tipoLocale == "Aula attrezzata CA2":
        return TipoLocale.Aula_CA2
    elif tipoLocale == "Aula attrezzata CA":
        return TipoLocale.Aula_CA
    elif tipoLocale == "Aula TableBox":
        return TipoLocale.Aula_TB
    elif tipoLocale == "Aula WallBox":
        return TipoLocale.Aula_WB
    elif tipoLocale == "LABINF":
        return TipoLocale.LABINF
    elif tipoLocale == "LAIB":
        return TipoLocale.LAIB
    elif tipoLocale == "LADISPE":
        return TipoLocale.LADISPE
    elif tipoLocale == "LED":
        return TipoLocale.LED
    elif tipoLocale == "LED1":
        return TipoLocale.LED1
    elif tipoLocale == "LED2":
        return TipoLocale.LED2
    elif tipoLocale == "ACSLAB":
        return TipoLocale.ACSLAB
    elif tipoLocale == "Aula 5T":
        return TipoLocale.Aula5T
    log.error_log("customTypes.getTipoLocaleFromString(): TipoLocale sconosciuto")
    return TipoLocale.Sconosciuto

def getStringFromTipoLocale(tipoLocale:TipoLocale) -> str:
    if tipoLocale == TipoLocale.AulaMultimediale:
        return "Aula multimediale"
    if tipoLocale == TipoLocale.Aula:
        return "Aula"
    if tipoLocale == TipoLocale.AulaAttrezzata:
        return "Aula attrezzata"
    if tipoLocale == TipoLocale.Laboratorio:
        return "Laboratorio"
    if tipoLocale == TipoLocale.Aula_CA2:
        return "Aula attrezzata CA2"
    if tipoLocale == TipoLocale.Aula_CA:
        return "Aula attrezzata CA"
    if tipoLocale == TipoLocale.Aula_TB:
        return "Aula TableBox"
    if tipoLocale == TipoLocale.Aula_WB:
        return "Aula WallBox"    
    if tipoLocale == TipoLocale.LABINF:
        return "LABINF"
    if tipoLocale == TipoLocale.LAIB:
        return "LAIB"
    if tipoLocale == TipoLocale.LADISPE:
        return "LADISPE"
    if tipoLocale == TipoLocale.LED:
        return "LED"
    if tipoLocale == TipoLocale.LED1:
        return "LED1"
    if tipoLocale == TipoLocale.LED2:
        return "LED2"
    if tipoLocale == TipoLocale.ACSLAB:
        return "ACSLAB"
    if tipoLocale == TipoLocale.Aula5T:
        return "Aula 5T"
    log.error_log("customTypes.getStringFromTipoLocale(): TipoLocale sconosciuto")
    return "?"



class PreseElettriche(Enum):
    Si = 2000
    No = 2001
    Preferibile = 2002
    Sconosciuto = 2003
    
def getPreseElettricheFromString(preseElettriche:str) -> PreseElettriche:
    if preseElettriche == "Si":
        return PreseElettriche.Si
    if preseElettriche == "No":
        return PreseElettriche.No
    if preseElettriche == "Preferibile":
        return PreseElettriche.Preferibile
    log.error_log("customTypes.getPreseElettricheFromString(): PreseElettriche sconosciute")
    return PreseElettriche.Sconosciuto

def getStringFromPreseElettriche(preseElettriche:PreseElettriche) -> str:
    if preseElettriche == PreseElettriche.Si:
        return "Si"
    if preseElettriche == PreseElettriche.No:
        return "No"
    if preseElettriche == PreseElettriche.Preferibile:
        return "Preferibile"
    log.error_log("customTypes.getStringFromPreseElettriche(): PreseElettriche sconosciute")
    return "?"    



class Squadra(Enum):
    NoSquadra = 3000
    Squadra_1 = 3001
    Squadra_2 = 3002
    Squadra_3 = 3003
    Squadra_4 = 3004
    
def getSquadraFromString(squadra:str) -> Squadra:
    if squadra == "Squadra 1":
        return Squadra.Squadra_1
    if squadra == "Squadra 2":
        return Squadra.Squadra_2
    if squadra == "Squadra 3":
        return Squadra.Squadra_3
    if squadra == "Squadra 4":
        return Squadra.Squadra_4
    return Squadra.NoSquadra

def getStringFromSquadra(squadra:Squadra) -> str:
    if squadra == Squadra.Squadra_1:
        return "Squadra 1"
    if squadra == Squadra.Squadra_2:
        return "Squadra 2"
    if squadra == Squadra.Squadra_3:
        return "Squadra 3"
    if squadra == Squadra.Squadra_4:
        return "Squadra 4"
    return "No squadra"        



class CapienzaLocale(Enum):
    '''TODO: stabilire quali categorie effettivamente servono'''
    Piccola = 1000
    # MedioPiccola = 1001 DEPRECATED
    Media = 1002
    MedioGrande = 1003
    Grande = 1004
    NonDisponibile = 9999
    
def getCapienzaLocaleFromString(capienzaLocale:str) -> CapienzaLocale:
    if capienzaLocale == "Piccola":
        return CapienzaLocale.Piccola
    # if capienzaLocale == "MedioPiccola":
        # return CapienzaLocale.MedioPiccola
    if capienzaLocale == "Media":
        return CapienzaLocale.Media
    if capienzaLocale == "MedioGrande":
        return CapienzaLocale.MedioGrande
    if capienzaLocale == "Grande":
        return CapienzaLocale.Grande
    return CapienzaLocale.NonDisponibile

def getStringFromCapienzaLocale(capienzaLocale:CapienzaLocale) -> str:
    if capienzaLocale == CapienzaLocale.Piccola:
        return "Piccola"
    # if capienzaLocale == CapienzaLocale.MedioPiccola:
        # return "MedioPiccola"
    if capienzaLocale == CapienzaLocale.Media:
        return "Media"
    if capienzaLocale == CapienzaLocale.MedioGrande:
        return "MedioGrande"
    if capienzaLocale == CapienzaLocale.Grande:
        return "Grande"
    return "NonDisponibile"

def getCapienzaFromNumStudenti(numStudenti:int) -> CapienzaLocale:
    '''Da configurare: qui si stabiliscono le fasce di Capienza delle Aule'''
    if numStudenti == 0:
        # per gli Insegnamenti di cui non conosco il numero di iscritti
        return CapienzaLocale.Media
    if numStudenti <= 100:
        return CapienzaLocale.Piccola
    # if numStudenti <= 100:
        # return CapienzaLocale.MedioPiccola
    if numStudenti <= 150:
        return CapienzaLocale.Media        
    if numStudenti <= 200:
        return CapienzaLocale.MedioGrande    
    return CapienzaLocale.Grande

def getNumStudentiFromCapienza(capienzaLocale:CapienzaLocale) -> int:
    '''Data la Capienza desiderata ritorna il numero di studenti associato. Da mantenere allineato con la
    funzione getCapienzaFromNumStudenti()'''
    if capienzaLocale == CapienzaLocale.Piccola:
        return 100
    # if capienzaLocale == CapienzaLocale.MedioPiccola:
        # return 100
    if capienzaLocale == CapienzaLocale.Media:
        return 150
    if capienzaLocale == CapienzaLocale.MedioGrande:
        return 200
    if capienzaLocale == CapienzaLocale.Grande:
        return 201
    if capienzaLocale == CapienzaLocale.NonDisponibile:
        log.error_log("customTypes.getNumStudentiFromCapienza(): CapienzaLocale sconosciuto")
        return 0



class Day(Enum):
    Indifferente = -1
    Lun = 0
    Mar = 1
    Mer = 2
    Gio = 3
    Ven = 4
    Sab = 5
    
def getIntFromDay(day:Day) -> int:
    if day == Day.Lun:
        return 0
    if day == Day.Mar:
        return 1
    if day == Day.Mer:
        return 2
    if day == Day.Gio:
        return 3
    if day == Day.Ven:
        return 4
    if day == Day.Sab:
        return 5
    log.error_log("customTypes.getIntFromDay(): Day sconosciuto")
    return -1

def getDayFromInt(day:int) -> Day:
    if day == 0:
        return Day.Lun
    if day == 1:
        return Day.Mar
    if day == 2:
        return Day.Mer
    if day == 3:
        return Day.Gio
    if day == 4:
        return Day.Ven
    if day == 5:
        return Day.Sab
    log.error_log("customTypes.getDayFromInt(): Day sconosciuto")
    return Day.Indifferente



class FasciaOraria(Enum):
    _Indifferente = -1
    _8_30 = 0
    _10_00 = 1
    _11_30 = 2
    _13_00 = 3
    _14_30 = 4
    _16_00 = 5
    _17_30 = 6
    
def getIntFromFasciaOraria(fasciaOraria:FasciaOraria) -> int:
    if fasciaOraria == FasciaOraria._8_30:
        return 0
    if fasciaOraria == FasciaOraria._10_00:
        return 1
    if fasciaOraria == FasciaOraria._11_30:
        return 2
    if fasciaOraria == FasciaOraria._13_00:
        return 3
    if fasciaOraria == FasciaOraria._14_30:
        return 4
    if fasciaOraria == FasciaOraria._16_00:
        return 5
    if fasciaOraria == FasciaOraria._17_30:
        return 6
    log.error_log("customTypes.getIntFromFasciaOraria(): fasciaOraria non specificata")
    return fasciaOraria._Indifferente


# def getSlotFromId(id):
#     ''' TODO change to version2'''
#     assert(id >= 0 and id < 7*5)
#     day:Day = Day.Indifferente
#     dayI = (id // 7) + 1
#     if dayI == 1:
#         day = Day.Lun
#     elif dayI == 2:
#         day = Day.Mar
#     elif dayI == 3:
#         day = Day.Mer
#     elif dayI == 4:
#         day = Day.Gio
#     elif dayI == 5:
#         day = Day.Ven
#     fasciaI = (id % 7) + 1
#     if fasciaI == 1:
#         return [day, FasciaOraria._8_30]
#     elif fasciaI == 2:
#         return [day, FasciaOraria._10_00]
#     elif fasciaI == 3:
#         return [day, FasciaOraria._11_30]
#     elif fasciaI == 4:
#         return [day, FasciaOraria._13_00]
#     elif fasciaI == 5:
#         return [day, FasciaOraria._14_30]
#     elif fasciaI == 6:
#         return [day, FasciaOraria._16_00]
#     else:
#         return [day, FasciaOraria._17_30]
    
def getStringsFromDayHour(day:int, hour:int) -> Tuple[str,str]:
    '''Return:\n
            [day, fasciaOraria]'''
    resD = "?"
    resF = "?"
    if day == 0:
        resD = "Lun"
    elif day == 1:
        resD = "Mar"
    elif day == 2:
        resD = "Mer"
    elif day == 3:
        resD = "Gio"
    elif day == 4:
        resD = "Ven"
    elif day == 5:
        resD = "Sab"
    if hour == 0:
        resF = "8.30-10.00"
    elif hour == 1:
        resF = "10.00-11.30"
    elif hour == 2:
        resF = "11.30-13.00"
    elif hour == 3:
        resF = "13.00-14.30"
    elif hour == 4:
        resF = "14.30-16.00"
    elif hour == 5:
        resF = "16.00-17.30"
    elif hour == 6:
        resF = "17.30-19.00"
    if resD == "?" or resF == "?":
        log.error_log("customTypes.getStringsFromDayHour(): resD o resH sconosciuti")
    return resD, resF
    
def getSlotFromDayHour(day:int, hour:int, numSlot:int) -> str:
    res = ""
    if day == 0:
        res = "Lun "
    elif day == 1:
        res = "Mar "
    elif day == 2:
        res = "Mer "
    elif day == 3:
        res = "Gio "
    elif day == 4:
        res = "Ven "
    elif day == 5:
        res = "Sab "
    else:
        res = "* "
    for i in range(2):
        if hour == -1:
            res += "*"
        elif hour == 0:
            res += "8:30"
        elif hour == 1:
            res += "10:00"
        elif hour == 2:
            res += "11:30"
        elif hour == 3:
            res += "13:00"
        elif hour == 4:
            res += "14:30"
        elif hour == 5:
            res += "16:00"
        elif hour == 6:
            res += "17:30"
        else:
            res += "19:00"
        if i == 0:
            res += "-"
            if hour != -1:
                hour+=numSlot
    return res

def getSlotFromHour(hour:int, numSlot:int) -> str:
    '''Con il prefisso per ordinamento di stringhe'''
    res = ""
    for i in range(2):
        if hour == 0:
            res += "8:30"
        elif hour == 1:
            res += "10:00"
        elif hour == 2:
            res += "11:30"
        elif hour == 3:
            res += "13:00"
        elif hour == 4:
            res += "14:30"
        elif hour == 5:
            res += "16:00"
        elif hour == 6:
            res += "17:30"
        else:
            res += "19:00"
        if i == 0:
            res += "-"
            hour+=numSlot
    return res

def getIdSlotFromString(day:str, fasciaOraria:str) -> Tuple[int,int]:
    '''Ritorna l'id corrispondente a giorno e fascia oraria passate. Compliant con schemaUseCase.xsd.\n
    Args:
        day (str): giorno
        fasciaOraria (str): fasciaOraria\n
    Returns:
        [idDay, idHour] (int, int): -1 se non esiste id univoco (i.e. uso special word "Indifferente")'''
    resD = 0
    resH = 0
    if day == "Indifferente" or fasciaOraria == "Indifferente":
        return -1,-1
    
    if day == "Lun":
        resD = 0
    elif day == "Mar":
        resD = 1
    elif day == "Mer":
        resD = 2
    elif day == "Gio":
        resD = 3
    elif day == "Ven":
        resD = 4
    elif day == "Sab":
        resD = 5
        
    if fasciaOraria == "8.30-10.00":
        resH = 0
    elif fasciaOraria == "10.00-11.30":
        resH = 1
    elif fasciaOraria == "11.30-13.00":
        resH = 2
    elif fasciaOraria == "13.00-14.30":
        resH = 3
    elif fasciaOraria == "14.30-16.00":
        resH = 4
    elif fasciaOraria == "16.00-17.30":
        resH = 5
    elif fasciaOraria == "17.30-19.00":
        resH = 6
        
    return resD, resH

def getDayFasciaOrariaFromString(day:str, fasciaOraria:str) -> Tuple[Day,FasciaOraria]:
    '''Ritorna l'id corrispondente a giorno e fascia oraria passate. Compliant con schemaUseCase.xsd.\n
    NB: concettualmente diversa da getIdSlotFromStrin()
    Returns:
        [idDay, idHour] (Day, FasciaOraria): -1 se non esiste id univoco (i.e. uso special word "Indifferente")'''
    resD = Day.Indifferente
    resH = FasciaOraria._Indifferente
    if day == "Indifferente":
        resD = Day.Indifferente
    if fasciaOraria == "Indifferente":
        resH = FasciaOraria._Indifferente
    
    if day == "Lun":
        resD = Day.Lun
    elif day == "Mar":
        resD = Day.Mar
    elif day == "Mer":
        resD = Day.Mer
    elif day == "Gio":
        resD = Day.Gio
    elif day == "Ven":
        resD = Day.Ven
    elif day == "Sab":
        resD = Day.Sab
        
    if fasciaOraria == "8.30-10.00":
        resH = FasciaOraria._8_30
    elif fasciaOraria == "10.00-11.30":
        resH = FasciaOraria._10_00
    elif fasciaOraria == "11.30-13.00":
        resH = FasciaOraria._11_30
    elif fasciaOraria == "13.00-14.30":
        resH = FasciaOraria._13_00
    elif fasciaOraria == "14.30-16.00":
        resH = FasciaOraria._14_30
    elif fasciaOraria == "16.00-17.30":
        resH = FasciaOraria._16_00
    elif fasciaOraria == "17.30-19.00":
        resH = FasciaOraria._17_30
        
    return resD, resH

def getIdGiornoFromString(day:str) -> int:
    '''Calcola l'id del giorno dalla stringa. Compliant con schemaUseCase.xsd
    
    Args:
        day (str): giorno
        
    Returns:
        idGiorno (int): return l'id corrispondente (0..4), -1 se sconosciuto
    '''
    res=0
    if day == "Lun":
        res = 0
    elif day == "Mar":
        res = 1
    elif day == "Mer":
        res = 2
    elif day == "Gio":
        res = 3
    elif day == "Ven":
        res = 4
    elif day == "Sab":
        res = 5
    else:
        log.error_log("customTypes.getIdGiornoFromString(): invalid arg day")
        return -1
    return res

def getIdFasciaOrariaFromString(fasciaOraria:str) -> int:
    '''Calcola l'id della fasciaOraria dalla stringa. Compliant con schemaUseCase.xsd
    
    Args:
        fasciaOraria (str): fasciaOraria
        
    Returns:
        idFasciaOraria (int): return l'id della fascia oraria nel primo giorno della settimana (0..6), -1 se sconosciuto
    '''
    if fasciaOraria == "8.30-10.00":
        return 0
    elif fasciaOraria == "10.00-11.30":
        return 1
    elif fasciaOraria == "11.30-13.00":
        return 2
    elif fasciaOraria == "13.00-14.30":
        return 3
    elif fasciaOraria == "14.30-16.00":
        return 4
    elif fasciaOraria == "16.00-17.30":
        return 5
    elif fasciaOraria == "17.30-19.00":
        return 6
    else:
        log.error_log("customTypes.getIdFasciaOrariaFromString(): invalid arg fasciaOraria: " + str(fasciaOraria))
        return -1
    
    
def dataCmp(f1:FasciaOraria, d1:Day, f2:FasciaOraria, d2:Day) -> int:
    '''Return:\n
        <0 se (f1,d1) è < di (f2,d2)\n
        =0 se (f1,d1) è == a (f2,d2)\n
        >0 se (f1,d1) è > di (f2,d2)'''
    if f1 == f2 and d1 == d2:
        return 0
    if d1 == d2:
        return getIntFromFasciaOraria(f1)-getIntFromFasciaOraria(f2)
    return getIntFromDay(d1)-getIntFromDay(d2)
    
 
 
class TipoSlot(Enum):
    SlotScelto = 0
    SlotGenerico = 1
    SlotPreferito = 2
    SlotScelto_giorno = 3
    '''Scelto solo il giorno'''
    SlotScelto_fasciaOraria = 4
    '''Scelgo solo la fascia oraria'''
    
    
    
class TipoScelta(Enum):
    '''TODO: per ora non viene implementato. Potrebbe riverlarsi del tutto inutile'''
    SlotPreciso = 0
    NonPrima = 1
    NonDopo = 2
    
    
    
class TipoErogazione(Enum):
    Presenza = 0 # default
    Remoto = 1
    
def getStringFromTipoErogazione(tipoErogazione:TipoErogazione) -> str:
    if tipoErogazione == TipoErogazione.Remoto:
        return "Remoto"
    if tipoErogazione == TipoErogazione.Presenza:
        return "Presenza"
    log.warning_log("customTypes.getStringFromTipoErogazione(): tipoErogazione non specificato -> gestito come TipoErogazione.Presenza")
    return "Presenza"
    
def getTipoErogazioneFromString(tipoErogazione:str) -> TipoErogazione:
    if tipoErogazione == "Remoto":
        return TipoErogazione.Remoto
    if tipoErogazione == "Presenza":
        return TipoErogazione.Presenza
    log.warning_log("customTypes.getStringFromTipoErogazione(): tipoErogazione non specificato -> gestito come TipoErogazione.Presenza")
    return TipoErogazione.Presenza    

    
    
class TipoLezione(Enum):
    EsercitazioneAula = 0
    EsercitazioneLaboratorio = 1
    Lezione = 2
    Lezione_EsercitazioneAula = 3
    
def getStringFromTipoLezione(tipoLez:TipoLezione) -> str:
    if tipoLez == TipoLezione.EsercitazioneAula:
        return "EA"
    if tipoLez == TipoLezione.EsercitazioneLaboratorio:
        return "EL"
    if tipoLez == TipoLezione.Lezione:
        return "L"
    if tipoLez == TipoLezione.Lezione_EsercitazioneAula:
        return "L_EA"
    log.error_log("customTypes.getStringFromTipoLezione() tipoLezione sconosciuto")
    
def getTipoLezioneFromStr(tipoLez:str):
    if tipoLez == "EA":
        return TipoLezione.EsercitazioneAula
    if tipoLez == "EL":
        return TipoLezione.EsercitazioneLaboratorio
    if tipoLez == "L":
        return TipoLezione.Lezione
    if tipoLez == "L_EA":
        return TipoLezione.Lezione_EsercitazioneAula
    log.error_log("customTypes.getTipoLezioneFromStr(): tipoLezione sconosciuto")
   
   
    
class TipoInsegnamento(Enum):
    '''(rispetto all'Orientamento)'''
    Obbligatorio = 0
    ObbligatorioAScelta = 1
    CreditoLibero = 2
    TabellaAScelta = 3
    CreditoLiberoConsigliato = 4
    Sconosciuto = -1
    
def getTipoInsegnamentoFromStr(tipoIns:str) -> TipoInsegnamento:
    '''TODO: se riesco ad identificare nuove tipologie e salvarle nel db => aggiornare questa funzione'''
    if tipoIns == "Credito_libero":
        return TipoInsegnamento.CreditoLibero
    if tipoIns == "Obbligatorio":
        return TipoInsegnamento.Obbligatorio
    if tipoIns == "Obbligatorio_a_scelta":
        return TipoInsegnamento.ObbligatorioAScelta
    if tipoIns == "Tabella_a_scelta":
        return TipoInsegnamento.TabellaAScelta
    if tipoIns == "Credito_libero_consigliato":
        return TipoInsegnamento.CreditoLiberoConsigliato
    return TipoInsegnamento.Sconosciuto

def getStrFromTipoInsegnamento(tipoIns:TipoInsegnamento) -> str:
    '''per inserire nel db'''
    if tipoIns == TipoInsegnamento.Obbligatorio:
        return "Obbligatorio"
    if tipoIns == TipoInsegnamento.ObbligatorioAScelta:
        return "Obbligatorio_a_scelta"
    if tipoIns == TipoInsegnamento.CreditoLibero:
        return "Credito_libero"
    if tipoIns == TipoInsegnamento.TabellaAScelta:
        return "Tabella_a_scelta"
    if tipoIns == TipoInsegnamento.CreditoLiberoConsigliato:
        return "Credito_libero_consigliato"
    if tipoIns == TipoInsegnamento.Sconosciuto:
        return "Sconosciuto"
    return "None"

 
    
class TipoCdl(Enum):
    Triennale = 0
    Magistrale = 1
    
class PeriodoDidattico(Enum):
    PrimoAnno_PrimoSemestre = 0
    PrimoAnno_SecondoSemestre = 1
    SecondoAnno_PrimoSemestre = 2
    SecondoAnno_SecondoSemestre = 3
    TerzoAnno_PrimoSemestre = 4
    TerzoAnno_SecondoSemestre = 5
    Altro = 6
    
def getPeriodoDidatticoFromStr(pd:str) -> PeriodoDidattico:
    if pd == "1-1":
        return PeriodoDidattico.PrimoAnno_PrimoSemestre
    if pd == "1-2":
        return PeriodoDidattico.PrimoAnno_SecondoSemestre
    if pd == "2-1":
        return PeriodoDidattico.SecondoAnno_PrimoSemestre
    if pd == "2-2":
        return PeriodoDidattico.SecondoAnno_SecondoSemestre
    if pd == "3-1":
        return PeriodoDidattico.TerzoAnno_PrimoSemestre
    if pd == "3-2":
        return PeriodoDidattico.TerzoAnno_SecondoSemestre
    log.error_log("customTypes.getPeriodoDidatticoFromStr(): periodo didattico sconosciuto: " + pd)
    return PeriodoDidattico.Altro

def getStringFromPeriodoDidattico(pd:PeriodoDidattico) -> str:
    if pd == PeriodoDidattico.PrimoAnno_PrimoSemestre:
        return "1-1"
    if pd == PeriodoDidattico.PrimoAnno_SecondoSemestre:
        return "1-2"
    if pd == PeriodoDidattico.SecondoAnno_PrimoSemestre:
        return "2-1"
    if pd == PeriodoDidattico.SecondoAnno_SecondoSemestre:
        return "2-2"
    if pd == PeriodoDidattico.TerzoAnno_PrimoSemestre:
        return "3-1"
    if pd == PeriodoDidattico.TerzoAnno_SecondoSemestre:
        return "3-2"
    log.error_log("customTypes.getStringFromPeriodoDidattico(): periodo didattico sconosciuto: " + pd)
    return "*-*"


class Alfabetica(Enum):
    '''Sono previste al massimo 3 Alfabetiche'''
    NoAlfabetica = 0
    PrimaAlfabetica = 1
    SecondaAlfabetica = 2
    TerzaAlfabetica = 3
    
def getAlfabeticaFromStr(alfabetica:str) -> Alfabetica:
    if alfabetica == '1':
        return Alfabetica.PrimaAlfabetica
    if alfabetica == '2':
        return Alfabetica.SecondaAlfabetica
    if alfabetica == '3':
        return Alfabetica.TerzaAlfabetica
    return Alfabetica.NoAlfabetica

def getStringFromAlfabetica(alfabetica:Alfabetica) -> str:
    if alfabetica == Alfabetica.PrimaAlfabetica:
        return '1'
    if alfabetica == Alfabetica.SecondaAlfabetica:
        return '2'
    if alfabetica == Alfabetica.TerzaAlfabetica:
        return '3'
    if alfabetica == Alfabetica.NoAlfabetica:
        return ''
    log.error_log("customTypes.getStringFromAlfabetica(): alfabetica sconosciuta")
    return '?'